require( "scripts/style.lua" );
require( "scripts/chocshopstyle.lua" );
require( "scripts/transitions.lua" );

insideGame = AreInsideGame();

MakeDialog
{
	name = "ok",
	
	VTintWindow
	{
	    x		= 0, 
	    y		= 0, 
	    w		= 800, 
	    h		= 600,
	    color	= Color( 0, 0, 0, 200 ),
	    time	= 200,
	    fade	= true
	},
	
	RBounceWindow
	{
		x			= 400 - gDialogTable.width/2, 
		y			= -600 - gDialogTable.height - 20,
	    targetposx	= 400 - (gDialogTable.width/2), 
	    targetposy	= 300 - (gDialogTable.height/2),
	    bouncelen	= 200, 
	    bouncefunc	= "sincx",
	    w			= gDialogTable.width,
	    h			= gDialogTable.height,
	    alpha       = true,
	    
		KSplit9Image
		{ 
			image	= "ui/backgrounds/split9_dialog_small",	
			x		= kCenter,
			y		= kCenter,
			w		= gDialogTable.width,
			h		= gDialogTable.height,
			x1		= 40,
			y1		= 40,
			x2		= 40,
			y2		= 40,
			
			---------------------------------------------- Title
			RShrinkText
			{
				x		= 12, 
				y		= 8,
				w		= kMax - 16,
				h		= 40,
				font	= Dialog_TitleFont,
				name	= "ok_title",
				flags	= kVAlignCenter + kHAlignCenter,
				label	= gDialogTable.title
			},
			
			---------------------------------------------- Body
			RShrinkText
			{
				x		= 16,
				y		= 46,
				w		= kMax-24,
				h		= kMax-70,
				font	= Dialog_BodyFont,
				name	= "ok_body",
				flags	= kVAlignCenter + kHAlignCenter,
				label	= gDialogTable.body
			},
	        
	        Bitmap{
		        x       = gDialogTable.width/2 - 80,
		        y       = kMax - 100,
		        image   = "ui/story/btn_trim_left",
	        },
	        Bitmap{
	            x       = gDialogTable.width/2 + 1,
	            y       = kMax - 100,
	            image   = "ui/story/btn_trim_left",
	            hflip   = true,
	        },
		
			---------------------------------------------- Ok
			SetStyle(CSOvalGreenButtonStyle);
            Button
            {
			    x		= gDialogTable.width/2 - 113 - 33,
                y		= kMax - 74 - 30, 
                label	= "app_ok",
                name	= "yes",
			    command =								-- Returns "yes" if pressed
				    function()
				        InsideGame(insideGame);
				        ModalReturn("yes");
				        PostMessage( CreateNamedMessage( kTintOff ) );
					    DoTransition( kBounceBack );
					    if( gDialogTable.yes ) then
					        gDialogTable.yes();
						else
						    CloseWindow();
					    end
				    end
            },
            ---------------------------------------------- Cancel
            SetStyle(CSOvalRedButtonStyle);
            Button
            {
			    x		= gDialogTable.width/2 + 33,
                y		= kMax - 74 - 30,   
                label	= "app_cancel",
                name	= "no",
                command	=								-- Returns "no" if pressed
				    function()
				        InsideGame(insideGame);
				        ModalReturn("no");
				        PostMessage( CreateNamedMessage( kTintOff ) );
					    DoTransition( kBounceBack );
					    if( gDialogTable.no ) then
					        gDialogTable.no();
						else
						    CloseWindow();
					    end
                    end
            },
		},
	},
}
InsideGame(false);